$Title: (3) Calculate AEZ-RB shares for ctl, oap, rmk, wol, frs

*      ----------------------------------------------------------------        *
*                                                                              *
*                      Global Trade Analysis Project                           *
*                           GTAP Water database                                *
*        (3) Calculate AEZ-RB shares for ctl, oap, rmk, wol, frs               *
*                                                                              *
*      ----------------------------------------------------------------        *
PARAMETER
  shr_frst         vertical rb-aez share parameter for forests landcover
  shr_pstr         vertical rb-aez share parameter for pasture landcover
  bas_shr_frst     vertical rb share
  bas_shr_pstr     vertical rb share
;
*   (1)  Initial is zero
shr_frst(r,a,b) = eps;
shr_pstr(r,a,b) = eps;
bas_shr_frst(r,a,b) = eps;
bas_shr_pstr(r,a,b) = eps;

*   (2) share based on landcover in land use database
bas_shr_frst(r,a,b)$sum(rb,frst(a,rb,r)) = frst(a,b,r)/sum(rb,frst(a,rb,r));
bas_shr_pstr(r,a,b)$sum(rb,pstr(a,rb,r)) = pstr(a,b,r)/sum(rb,pstr(a,rb,r));

*   (3) share if we have no riverbasin info
bas_shr_frst(r,a,'rb500')$(not sum(rb,frst(a,rb,r))) = 1;
bas_shr_pstr(r,a,'rb500')$(not sum(rb,pstr(a,rb,r))) = 1;

*   (4) final share
shr_pstr(r,a,b)     =  bas_shr_pstr(r,a,b)*aez_shr(a,'ctl',r);
shr_frst(r,a,b)     =  bas_shr_frst(r,a,b)*aez_shr(a,'frs',r);
